/*
 * Decompiled with CFR 0.152.
 */
package draylar.omegaconfig;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import draylar.omegaconfig.api.Comment;
import draylar.omegaconfig.api.Config;
import draylar.omegaconfig.gson.SyncableExclusionStrategy;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmegaConfig
implements ModInitializer {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final class_2960 CONFIG_SYNC_PACKET = new class_2960("omegaconfig", "sync");
    public static final Gson SYNC_ONLY_GSON = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new SyncableExclusionStrategy()).setPrettyPrinting().create();
    public static final Logger LOGGER = LogManager.getLogger();
    private static final List<Config> REGISTERED_CONFIGURATIONS = new ArrayList<Config>();

    public void onInitialize() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> server.execute(() -> {
            class_2540 packet = new class_2540(Unpooled.buffer());
            class_2487 root = new class_2487();
            class_2499 configurations = new class_2499();
            OmegaConfig.getRegisteredConfigurations().forEach(config -> {
                if (config.hasAnySyncable()) {
                    configurations.add((Object)config.writeSyncingTag());
                }
            });
            root.method_10566("Configurations", (class_2520)configurations);
            packet.method_10794(root);
            handler.method_14364(ServerPlayNetworking.createS2CPacket((class_2960)CONFIG_SYNC_PACKET, (class_2540)packet));
        }));
    }

    public static <T extends Config> T register(Class<T> configClass) {
        try {
            Config config = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!OmegaConfig.configExists(config)) {
                config.save();
                REGISTERED_CONFIGURATIONS.add(config);
            } else {
                try {
                    List<String> lines = Files.readAllLines(OmegaConfig.getConfigPath(config));
                    lines.removeIf(line -> line.trim().startsWith("//"));
                    StringBuilder res = new StringBuilder();
                    lines.forEach(res::append);
                    Config object = (Config)GSON.fromJson(res.toString(), configClass);
                    object.save();
                    REGISTERED_CONFIGURATIONS.add(object);
                    return (T)object;
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                    LOGGER.info(String.format("Encountered an error while reading %s config, falling back to default values.", config.getName()));
                    LOGGER.info(String.format("If this problem persists, delete the config file %s and try again.", config.getName() + "." + config.getExtension()));
                }
            }
            return (T)config;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            exception.printStackTrace();
            throw new RuntimeException("No valid constructor found for: " + configClass.getName());
        }
    }

    public static <T extends Config> void writeConfig(Class<T> configClass, T instance) {
        String json = GSON.toJson(instance);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(json.split("\n")));
        TreeMap<Integer, Object> insertions = new TreeMap<Integer, Object>();
        HashMap<String, String> keyToComments = new HashMap<String, String>();
        for (Field field : configClass.getDeclaredFields()) {
            OmegaConfig.addFieldComments(field, keyToComments);
        }
        for (Class clazz : OmegaConfig.flatten(configClass.getDeclaredClasses())) {
            for (Field field : clazz.getDeclaredFields()) {
                OmegaConfig.addFieldComments(field, keyToComments);
            }
        }
        block5: for (int i = 0; i < lines.size(); ++i) {
            String string = (String)lines.get(i);
            String startingWhitespace = OmegaConfig.getStartingWhitespace(string);
            for (Map.Entry entry : keyToComments.entrySet()) {
                Object comment = (String)entry.getValue();
                if (!string.trim().startsWith(String.format("\"%s\"", entry.getKey()))) continue;
                comment = ((String)comment).contains("\n") ? startingWhitespace + "//" + String.join((CharSequence)String.format("\n%s//", startingWhitespace), ((String)comment).split("\n")) : String.format("%s//%s", startingWhitespace, comment);
                insertions.put(i + insertions.size(), comment);
                continue block5;
            }
        }
        for (Map.Entry entry : insertions.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            lines.add(key, value);
        }
        StringBuilder res = new StringBuilder();
        lines.forEach(str -> res.append(String.format("%s%n", str)));
        try {
            Path path = OmegaConfig.getConfigPath(instance);
            path.toFile().getParentFile().mkdirs();
            Files.write(path, res.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)iOException);
            LOGGER.info(String.format("Write error, using default values for config %s.", configClass));
        }
    }

    public static List<Class<?>> flatten(Class<?>[] array) {
        ArrayList list = new ArrayList();
        for (Class<?> clazz : array) {
            OmegaConfig.populateRecursively(list, clazz);
        }
        return list;
    }

    private static void populateRecursively(List<Class<?>> list, Class<?> aClass) {
        list.add(aClass);
        Class<?>[] classes = aClass.getDeclaredClasses();
        if (classes.length != 0) {
            for (Class<?> clazz : classes) {
                OmegaConfig.populateRecursively(list, clazz);
            }
        }
    }

    private static void addFieldComments(Field field, Map<String, String> keyToComments) {
        Annotation[] annotations;
        String fieldName = field.getName();
        for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Comment)) continue;
            keyToComments.put(fieldName, ((Comment)annotation).value());
            break;
        }
    }

    private static String getStartingWhitespace(String input) {
        int index = -1;
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char at = chars[i];
            if (at == ' ') continue;
            index = i;
            break;
        }
        if (index != -1) {
            return input.substring(0, index);
        }
        return "";
    }

    public static Path getConfigPath(Config config) {
        return Paths.get(FabricLoader.getInstance().getConfigDir().toString(), config.getDirectory(), String.format("%s.%s", config.getName(), config.getExtension()));
    }

    public static boolean configExists(Config config) {
        return Files.exists(OmegaConfig.getConfigPath(config), new LinkOption[0]);
    }

    public static List<Config> getRegisteredConfigurations() {
        return REGISTERED_CONFIGURATIONS;
    }
}

